package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Locale;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.EntidadGestoraColaboradora;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b78s00DaoImpl generated by UDA, 11-Jan-2017 12:23:07.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EntidadGestoraColaboradoraDaoImpl implements
		EntidadGestoraColaboradoraDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.CODENTIAT_078 CODENTIAT078, t1.DESENTIAT_EU_078 DESENTIATEU078, t1.DESENTIAT_ES_078 DESENTIATES078, t1.FECBAJ_078 FECBAJ078 FROM AB0478S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EntidadGestoraColaboradora> rwMap = new RowMapper<EntidadGestoraColaboradora>() {
		public EntidadGestoraColaboradora mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EntidadGestoraColaboradora(
					resultSet.getString("CODENTIAT078"),
					resultSet.getString("DESENTIATEU078"),
					resultSet.getString("DESENTIATES078"),
					resultSet.getDate("FECBAJ078"));
		}
	};

	private RowMapper<EntidadGestoraColaboradora> rwMapPK = new RowMapper<EntidadGestoraColaboradora>() {
		public EntidadGestoraColaboradora mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EntidadGestoraColaboradora(
					resultSet.getString("CODENTIAT078"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00 Ab04b78s00
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @return the entidad gestora colaboradora
	 */
	public EntidadGestoraColaboradora add(EntidadGestoraColaboradora ab0478s00) {
		Long entidadGestoraPK = Secuencias.ENTIDAD_GESTORA
				.getNextLong(this.jdbcTemplate);
		if (entidadGestoraPK != null) {
			ab0478s00.setCodentiat078(entidadGestoraPK.toString());
		}

		String query = "INSERT INTO AB0478S00 (CODENTIAT_078, DESENTIAT_EU_078, DESENTIAT_ES_078, FECBAJ_078) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab0478s00.getCodentiat078(),
				ab0478s00.getDesentiatEu078(), ab0478s00.getDesentiatEs078(),
				ab0478s00.getFecbaj078());
		return ab0478s00;
	}

	/**
	 * Updates a single row in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00 Ab04b78s00
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @return the entidad gestora colaboradora
	 */
	public EntidadGestoraColaboradora update(
			EntidadGestoraColaboradora ab0478s00) {
		String query = "UPDATE AB0478S00 SET DESENTIAT_EU_078=?, DESENTIAT_ES_078=?, FECBAJ_078=? WHERE CODENTIAT_078=? ";
		this.jdbcTemplate.update(query, ab0478s00.getDesentiatEu078(),
				ab0478s00.getDesentiatEs078(), ab0478s00.getFecbaj078(),
				ab0478s00.getCodentiat078());
		return ab0478s00;
	}

	/**
	 * Finds a single row in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00 Ab04b78s00
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @return the entidad gestora colaboradora
	 */
	@Transactional(readOnly = true)
	public EntidadGestoraColaboradora find(EntidadGestoraColaboradora ab0478s00) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CODENTIAT_078 = ?");

		List<EntidadGestoraColaboradora> ab0478s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap,
						ab0478s00.getCodentiat078());
		return (EntidadGestoraColaboradora) DataAccessUtils
				.uniqueResult(ab0478s00List);
	}

	/**
	 * Removes a single row in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 */
	public void remove(EntidadGestoraColaboradora ab0478s00) {
		String query = "DELETE FROM AB0478S00 WHERE CODENTIAT_078=?";
		this.jdbcTemplate.update(query, ab0478s00.getCodentiat078());
	}

	/**
	 * Finds a list of rows in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00 jqGridRequestDto JQGridRequestDto List<Ab04b78s00>
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EntidadGestoraColaboradora> findAll(
			EntidadGestoraColaboradora ab0478s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0478s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		Locale locale = LocaleContextHolder.getLocale();
		if ("es".equals(locale.getLanguage())) {
			query.append(" ORDER BY t1.CODENTIAT_078 ");
		} else {
			query.append(" ORDER BY t1.CODENTIAT_078 ");
		}
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EntidadGestoraColaboradora>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b78s00 table using like.
	 * 
	 * ab0478s00 Ab04b78s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab04b78s00>
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EntidadGestoraColaboradora> findAllLike(
			EntidadGestoraColaboradora ab0478s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0478s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EntidadGestoraColaboradora>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b78s00 table.
	 * 
	 * ab0478s00 Ab04b78s00 Long
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EntidadGestoraColaboradora ab0478s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0478S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0478s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b78s00 table using like.
	 * 
	 * ab0478s00 Ab04b78s00 startsWith Boolean Long
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EntidadGestoraColaboradora ab0478s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0478S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0478s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b78s00 selected for rup_table.
	 * 
	 * ab0478s00 Ab04b78s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab04b78s00>>
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EntidadGestoraColaboradora>> reorderSelection(
			EntidadGestoraColaboradora ab0478s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0478s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EntidadGestoraColaboradora.class,
				filterParamList,
				"CODENTIAT_078,DESENTIAT_EU_078,DESENTIAT_ES_078,FECBAJ_078");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EntidadGestoraColaboradora>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab04b78s00 searchParams Ab04b78s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab04b78s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EntidadGestoraColaboradora>> search(
			EntidadGestoraColaboradora filterParams,
			EntidadGestoraColaboradora searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EntidadGestoraColaboradora.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"CODENTIAT_078,DESENTIAT_EU_078,DESENTIAT_ES_078,FECBAJ_078");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EntidadGestoraColaboradora>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab0478s00 Ab04b78s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterab0478s00
	 *            the filterab 0478 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override()
	public void removeMultiple(EntidadGestoraColaboradora filterab0478s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.QUERY_SELECT);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0478s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						EntidadGestoraColaboradora.class, query, params,
						"CODENTIAT_078,DESENTIAT_EU_078,DESENTIAT_ES_078,FECBAJ_078");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b78s00 entity.
	 * 
	 * ab0478s00 Ab04b78s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EntidadGestoraColaboradora ab0478s00) {

		StringBuilder where = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0478s00 != null && ab0478s00.getCodentiat078() != null) {
			where.append(" AND t1.CODENTIAT_078 = ?");
			params.add(ab0478s00.getCodentiat078());
		}
		if (ab0478s00 != null && ab0478s00.getDesentiatEu078() != null) {
			where.append(" AND t1.DESENTIAT_EU_078 = ?");
			params.add(ab0478s00.getDesentiatEu078());
		}
		if (ab0478s00 != null && ab0478s00.getDesentiatEs078() != null) {
			where.append(" AND t1.DESENTIAT_ES_078 = ?");
			params.add(ab0478s00.getDesentiatEs078());
		}
		if (ab0478s00 != null && ab0478s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_078 >= ?");
			params.add(ab0478s00.getFecbajaDesde());
		}
		if (ab0478s00 != null && ab0478s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_078 <= ?");
			params.add(ab0478s00.getFecbajaHasta());
		}
		// where.append(" AND (t1.FECBAJ_078 IS NULL OR t1.FECBAJ_078 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b78s00 entity.
	 * 
	 * ab0478s00 Ab04b78s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0478s00
	 *            the ab 0478 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			EntidadGestoraColaboradora ab0478s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EntidadGestoraColaboradoraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0478s00 != null && ab0478s00.getCodentiat078() != null) {
			where.append(" AND UPPER(t1.CODENTIAT_078) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0478s00.getCodentiat078().toUpperCase() + "%");
			} else {
				params.add("%" + ab0478s00.getCodentiat078().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CODENTIAT_078 IS NOT NULL");
		}
		if (ab0478s00 != null && ab0478s00.getDesentiatEu078() != null) {
			where.append(" AND UPPER(t1.DESENTIAT_EU_078) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0478s00.getDesentiatEu078().toUpperCase() + "%");
			} else {
				params.add("%" + ab0478s00.getDesentiatEu078().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESENTIAT_EU_078 IS NOT NULL");
		}
		if (ab0478s00 != null && ab0478s00.getDesentiatEs078() != null) {
			where.append(" AND UPPER(t1.DESENTIAT_ES_078) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0478s00.getDesentiatEs078().toUpperCase() + "%");
			} else {
				params.add("%" + ab0478s00.getDesentiatEs078().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESENTIAT_ES_078 IS NOT NULL");
		}
		if (ab0478s00 != null && ab0478s00.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_078 >= ?");
			params.add(ab0478s00.getFecbajaDesde());
		}
		if (ab0478s00 != null && ab0478s00.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_078 <= ?");
			params.add(ab0478s00.getFecbajaHasta());
		}
		if (ab0478s00 != null && ab0478s00.getFecbajaDesde() == null
				&& ab0478s00.getFecbajaHasta() == null) {
			where.append(" AND (t1.FECBAJ_078 IS NULL OR t1.FECBAJ_078 > SYSDATE)");
		}
		// where.append(" AND (t1.FECBAJ_078 IS NULL OR t1.FECBAJ_078 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
